//
//  BPServerAvailability.h
//  BIViews
//
//  Created by Alykhan Jetha on 11-02-08.
//  Copyright 2011 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BIDatabaseObjectContext;
@class BPDownloadManager;
@class MCReachability;

@interface BPServerAvailability : NSObject {
	//NSTimeInterval retryThreshold; // default is 3 minutes
	//NSDate *lastTry;
	BOOL lastResult;
	BPDownloadManager *downloadManager;
	NSError *lastError;
	NSInteger lastReturnCode;
	//MCReachability *webHostReachability;
}
/*!
 Uses the context the first time only to get a proper URL to test with along with username and password.
 */
+ (BPServerAvailability *)defaultServerAvailabilityUsingContext:(BIDatabaseObjectContext *)aContext;

//@property (assign) NSTimeInterval retryThreshold;
@property (assign) BOOL lastResult;
//@property (nonatomic,retain) NSDate *lastTry;
@property (nonatomic,assign) BPDownloadManager *downloadManager;
@property (nonatomic,retain) NSError *lastError;
//@property (retain) MCReachability *webHostReachability;
@property NSInteger lastReturnCode;

- (id)initUsingContext:(BIDatabaseObjectContext *)aContext;

/*!
 Uses reachability to see if we can make it to the web host (the machine hosting bphttp) - this is different than actually hitting the web server with credentials.
 */
- (BOOL)isWebHostReachable;

/*!
 Uses reachability to see if we can make it to the accessd host - this is different than actually hitting accessd with credentials. For self-serve, the syncHost and webHost will be the same, but for cloud, these may be different.
 */
- (BOOL)isSyncHostReachable;

/*!
 Tries to see if apple.com is reachable.
 */
- (BOOL)isReferenceHostReachable;


- (NSString *)hostname;
- (NSString *)syncHostname;

- (BOOL)isCloudAccount;
- (NSURL *)cloudStatusURL;

- (NSURL *)controlPanelURL;
- (BOOL)isControlPanelReachable;


/*!
 Returns the http code for the request of the next document number of this type. If the code is 200 (http ok), then the objectNumber will be returned and can be used in the document generation. If the http code is 402, then we must tell the user that the account has reached the max for this type of document for the month. If the http code is anything else, then we need to handle the error appropriately. Return code of 0 is a timeout.
 */
- (NSUInteger)codeForGenerationOfPDFOfType:(NSString *)aType objectNumber:(NSNumber **)aNumber;

@end
